//TIM BLYTHMAN 7/2/20
//Routines for WS2812
//changed to RA5 24/9/20 for use in DLC LED Slave

#include "io.h"

void ioinit(void){
    //analog pins are these only: RA4=AN3
    ANSELA=0;
    ANSELC=0;
    ANSA4=1;
    //ADCON1=0b11010000;      //11010000 =  Right justified, FOSC/16, VREF is VDD
    ADCON1=0b11110000;      //11010000 =  Right justified, FRC, VREF is VDD
    ADCON0=0b00000001;      //ADC on, no conversion yet
    //pin for LED control
    LATA5=0;
    TRISA5=0;
}

void setOptions(void){
//#define ADD_4 C2
//#define ADD_8 C1
//#define ADD_16 C0
//#define ADD_32 C3
//#define RGB_SELECT C4
//unsigned char baseAddress=0;           //for address offset
//unsigned char outputMode=OUTPUT_RGB;   //colour mode

//16F1455 PORTC doesn't have WPU, so we briefly pull each pin high to test it

    baseAddress=0;
    
    TRISC2=1;
    LATC2=1;
    TRISC2=0;
    TRISC2=1;
    if(RC2==0){baseAddress=baseAddress+4;}
    
    TRISC1=1;
    LATC1=1;
    TRISC1=0;
    TRISC1=1;
    if(RC1==0){baseAddress=baseAddress+8;}

    TRISC0=1;
    LATC0=1;
    TRISC0=0;
    TRISC0=1;
    if(RC0==0){baseAddress=baseAddress+16;}

    TRISC3=1;
    LATC3=1;
    TRISC3=0;
    TRISC3=1;
    if(RC3==0){baseAddress=baseAddress+32;}

    TRISC4=1;
    LATC4=1;
    TRISC4=0;
    TRISC4=1;
    if(RC4==0){outputMode=OUTPUT_WHITE;}else{outputMode=OUTPUT_RGB;}
}

int getADC(char channel){           //get ADC result from channel
    ADCON0=(channel<<2)|1;          //set channel, ADC on
    ADCON0bits.ADGO=1;              //start
    while(ADCON0bits.ADGO){}        //wait till done
    return ((ADRESH&3)<<8)|(ADRESL);//10 bit result
}

void sendLEDdata(void){             //send WS2812 data, 64 LEDs=1536 bits
    //mix of C and assembly
    //use FSR1 to step through array
    //RGBptr counts when we've sent all bytes
    //each ASM loop sends one byte (~120 words of program memory)
    //if space is available, could expand to do an entire 24-bit RGB word
    //output is fixed to RA5
    //timing is 5 cycles high, 10 cycles low for 0, 10 cycles high, 5 cycles low for 1, 12MHz instruction clock => 15 instruction = 1.25us
    //reset pulse is not enforced, software must provide delay
    //total cycle for 64 RGB LEDs is ~1.92ms
    unsigned int fsr;       //to store FSR that compiler may be using
    di();                   //disable interrupts
    fsr = FSR1;             //save
    FSR1=(unsigned int)&RGBdata[0][0];      //set to start of array
    RGBptr=192;             //RGBptr is set as __near to allow it to be used without worrying about banks
asm("INNERLOOP:");
//bit 7
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x7");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 6
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x6");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 5
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x5");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 4
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x4");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 3
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x3");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 2
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x2");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 1
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x1");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 0 and increment counter/pointer
asm("BSF PORTA, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x0");    //skip next if 1
asm("BCF PORTA, 0x5");      //output low if 0
asm("MOVLW 0x1");           //increment pointer (use ADDFSR for single opcode instead?)
asm("ADDWF FSR1L, F");      //low byte
asm("MOVLW 0x0");
asm("ADDWFC FSR1H, F");     //high byte with carry
asm("BCF PORTA, 0x5");      //output low if 1
asm("NOP");
asm("DECFSZ _RGBptr");      //count bits and test
asm("GOTO INNERLOOP;");     //loop
    FSR1=fsr;               //restore
    ei();                   //enable interrupts
}
